<?php
include 'db.php'; // Include your database connection file

header("Content-Type: application/json");

// Check if the request method is POST
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(["status" => "error", "message" => "Invalid request method"]);
    exit;
}

// Retrieve input data from POST request
$Data = json_decode(file_get_contents("php://input"), true);

$blog_title = $Data['Blog_Title'] ?? null;
$by_name = $Data['By_name'] ?? null;
$description = $Data['description'] ?? null;
$blog_image = $Data['Blog_image'] ?? null;
$date = $Data['date'] ?? null;
$category = $Data['Category'] ?? null;
$youtube_link = $Data['Youtube_link'] ?? null;
$position = $Data['position'] ?? null;

// Validate required fields
if (!$blog_title || !$by_name || !$description || !$category) {
    echo json_encode(["status" => "error", "message" => "Blog Title, Author Name, Description, and Category are required"]);
    exit;
}

// Sanitize input to prevent SQL injection
$blog_title = mysqli_real_escape_string($conn, $blog_title);
$by_name = mysqli_real_escape_string($conn, $by_name);
$description = mysqli_real_escape_string($conn, $description);
$blog_image = mysqli_real_escape_string($conn, $blog_image);
$date = mysqli_real_escape_string($conn, $date);
$category = mysqli_real_escape_string($conn, $category);
$youtube_link = mysqli_real_escape_string($conn, $youtube_link);
$position = intval($position);

// Insert query to add a new blog
$query = "INSERT INTO blogs (Blog_Title, By_name, description, Blog_image, date, Category, Youtube_link, position) 
          VALUES ('$blog_title', '$by_name', '$description', '$blog_image', '$date', '$category', '$youtube_link', '$position')";

// Execute the query and check for success
if (mysqli_query($conn, $query)) {
    echo json_encode(["status" => "success", "message" => "Blog record inserted successfully"]);
} else {
    echo json_encode(["status" => "error", "message" => "Failed to insert blog record"]);
}
?>
